<?php
/* --------------------------------------------------------------
 SlimAppRegistration.php 2020-03-10
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Kernel\Bootstrapper;

use Gambio\Core\Application\Application;
use Gambio\Core\Application\Kernel\AbstractBootstrapper;
use Psr\Http\Message\ResponseFactoryInterface;
use Slim\App as SlimApp;
use Slim\Factory\AppFactory;
use Slim\Interfaces\CallableResolverInterface;

/**
 * Class SlimAppRegistration
 * @package Gambio\Core\Application\Kernel\Bootstrapper
 */
class SlimAppRegistration extends AbstractBootstrapper
{
    /**
     * @inheritDoc
     */
    public function boot(Application $application): void
    {
        $application->add(ResponseFactoryInterface::class,
            static function () {
                return AppFactory::determineResponseFactory();
            });
        
        $slim = AppFactory::createFromContainer($application);
        $application->share(SlimApp::class, $slim);
        $application->share(CallableResolverInterface::class, $slim->getCallableResolver());
    }
}